﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace Malefiz.Klassen_für_Spielbrett
{
    class Haus
    {
        private Figurennummerierung nummerierung = new Figurennummerierung();

        

        /// <summary>
        /// In dieser Eigenschaft wird die Spielernummer und die Hausnummer (also die Figurennummer) 
        /// des Spielers gespeichert werden, dem dieses Hausfeld gehört.
        /// </summary>
        public Figurennummerierung Nummerierung
        {
            get { return nummerierung; }
        }

        /// <summary>
        /// In dieser Eigenschaft soll die Spielernummer des Spielers gespeichert werden, dem dieses Haus gehört. 
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler
        /// </summary>
        public int Spielernummer
        {
            get { return nummerierung.SpielerNummer; }
        }

        /// <summary>
        /// In dieser Eigenschaft soll die Figurennummer des Spielers gespeichert werden, dem dieses Haus gehört.
        /// Jede Figur ist über ihre Figurennummer einem bestimmten Hausfeld zugeordnet ist.
        /// 0: Erste Spielfigur ... 4: Fünfte Spielfigur
        /// </summary>
        public int Figurennummer
        {
            get { return nummerierung.FigurenNummer; }
        }


        
        bool istBelegt;

        /// <summary>
        /// Soll auf true gesetzt werden, wenn das Hausfeld aktuell von seiner Spielfigur besetzt ist. 
        /// Zur Initialisierung des Feldes steht diese Eigenschaft auf true.
        /// Wird sie auf true gesetzt, so wird dadurch das richtige Figurenporträt auf das Hausfeld gesetzt. 
        /// Wird sie auf false gesetzt, so wird das transparente Bild auf das Hausfeld gesetzt.
        /// </summary>
        public bool IstBelegt
        {
            get { return istBelegt; }
            set 
            { 
                istBelegt = value;

                if (istBelegt == true)
                {
                    if (Spielernummer == 0)
                    { this.figurenporträt = pictures.Figur_rot; }
                    if (Spielernummer == 1)
                    { this.figurenporträt = pictures.Figur_grün; }
                    if (Spielernummer == 2)
                    { this.figurenporträt = pictures.Figur_gelb; }
                    if (Spielernummer == 3)
                    { this.figurenporträt = pictures.Figur_blau; }
                }

                if (istBelegt == false)
                {
                    this.figurenporträt = pictures.Transparent;
                }
            }
        }



        private Image figurenporträt;

        /// <summary>
        /// In dieser Eigenschaft kann das Figurenporträt der Spielfigur abgerufen werden, der dieses Hausfeld gehört.
        /// (z.B. Figur_rot für eine Spielfigur des roten Spielers)
        /// Diese Eigenschaft ändert sich im Laufe des Spieles nicht und wurde schon zur Initialisierung 
        /// auf das richtige Figurenporträt dieses Spielers gesetzt.
        /// </summary>
        public Image Figurenporträt
        {
            get { return figurenporträt; }
        }

        Feldposition startfeld = new Feldposition();

        /// <summary>
        /// Gibt die Startposition einer Figur an, die gerade aus dem Haus gekommen ist:
        /// 2,0 beim roten Spieler; 6,0 beim grünen Spieler; 10,0 beim gelben Spieler und 14,0 beim blauen Spieler.
        /// </summary>
        public Feldposition Startfeld
        {
            get { return startfeld; }
        }



        //Konstruktoren
        public Haus()
        {
            IstBelegt = true;
        }

        /// <summary>
        /// Erstellt ein Hausfeld mit einer spielernummer und einer figurennummer. 
        /// Dabei ist jede Figur über ihre Figurennummer einem bestimmten Hausfeld zugeordnet.
        /// Zur Initialisierung wird jedem Hausfeld das Figurenporträt seiner Spielfigur in die Eigenschaft Figurenporträt gespeichert.
        /// (z.B. Figur_rot für das Hausfeld einer Spielfigur des roten Spielers)
        /// Voreinstellungen:
        /// IstBelegt = true
        /// </summary>
        /// <param name="spielernummer">Die Nummer des Spielers, dem das Haus gehört:
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler</param>
        /// <param name="figurnummer">Jede Figur ist über ihre figurennummer einem bestimmten Hausfeld zugeordnet ist:
        /// 0: Erste Spielfigur ... 4: Fünfte Spielfigur</param>
        public Haus(int spielernummer, int figurnummer) : this()
        {
            nummerierung.SpielerNummer = spielernummer;
            nummerierung.FigurenNummer = figurnummer;

            startfeld.Y = 0;
            if (spielernummer == 0)                     //Roter Spieler
            { figurenporträt = pictures.Figur_rot; startfeld.X = 2; }
            if (spielernummer == 1)                     //Grüner Spieler
            { figurenporträt = pictures.Figur_grün; startfeld.X = 6; }
            if (spielernummer == 2)                     //Gelber Spieler
            { figurenporträt = pictures.Figur_gelb; startfeld.X = 10; }
            if (spielernummer == 3)                     //Blauer Spieler
            { figurenporträt = pictures.Figur_blau; startfeld.X = 14; }
        }
    }
}